<?php

namespace Database\Seeders\Themes\Insurance;

use Botble\Widget\Widgets\CoreSimpleMenu;

class WidgetSeeder extends \Database\Seeders\Themes\Main\WidgetSeeder
{
    public function getDataTopFooterSidebar(): array
    {
        return [];
    }

    public function getDataFooterSidebar(): array
    {
        return [
            [
                'widget_id' => 'SiteInformationWidget',
                'sidebar_id' => 'footer_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'SiteInformationWidget',
                    'logo' => $this->filePath('icons/logo-white.png'),
                    'description' => 'Felis consquat magnis fames sagittis ultrices plasodales porttitor quisque ultrice tempor turpis.',
                    'background_color' => 'rgb(20, 23, 108)',
                    'display_social_links' => true,
                    'quantity' => 0,
                    'style' => 'style-2',
                ],
            ],
            [
                'widget_id' => CoreSimpleMenu::class,
                'sidebar_id' => 'footer_sidebar',
                'position' => 2,
                'data' => [
                    'id' => CoreSimpleMenu::class,
                    'name' => 'Information',
                    'items' => [
                        [
                            [
                                'key' => 'label',
                                'value' => '+123 888 9999',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'tel:+123 888 9999',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-phone-call',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'info@apexa.com',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'mailto:info@apexa.com',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-mail',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Sydney Harbour Bridge Circular City of Sydney, Australia.',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-map-pin',
                            ],
                        ],
                    ],
                ],
            ],
            [
                'widget_id' => CoreSimpleMenu::class,
                'sidebar_id' => 'footer_sidebar',
                'position' => 3,
                'data' => [
                    'id' => CoreSimpleMenu::class,
                    'name' => 'Top Links',
                    'items' => [
                        [
                            [
                                'key' => 'label',
                                'value' => 'How it’s Work',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/how-its-work',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Partners',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/team-one',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Testimonials',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/testimonials',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Case Studies',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/contact-us',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Pricing',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/pricing',
                            ],
                        ],
                    ],
                ],
            ],
            [
                'widget_id' => 'GalleriesWidget',
                'sidebar_id' => 'footer_sidebar',
                'position' => 4,
                'data' => [
                    'id' => 'GalleriesWidget',
                    'title' => 'Instagram Posts',
                    'limit' => 6,
                ],
            ],
        ];
    }
}
