<?php
    $bgColor = $shortcode->background_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;
?>

<section
    class="pricing__area pricing__bg shortcode-pricing"
    style="<?php echo \Illuminate\Support\Arr::toCssStyles([
        "--background-color: $bgColor" => $bgColor,
        "--background-image: url('$bgImage')" => $bgImage,
    ]) ?>"
>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-5">
                <div class="section-title text-center mb-30 tg-heading-subheading animation-style3">
                    <?php if($subtitle = $shortcode->subtitle): ?>
                        <span class="sub-title"><?php echo BaseHelper::clean($subtitle); ?></span>
                    <?php endif; ?>

                    <?php if($title = $shortcode->title): ?>
                        <h2 class="title tg-element-title"><?php echo BaseHelper::clean($title); ?></h2>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="pricing__item-wrap">
            <div class="pricing__tab">
                <span class="pricing__tab-btn monthly_tab_title"><?php echo e(__('Monthly')); ?></span>
                <span class="pricing__tab-switcher"></span>
                <span class="pricing__tab-btn annual_tab_title"><?php echo e(__('Yearly')); ?></span>
            </div>
            <div class="row justify-content-center">
                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6 col-sm-8">
                        <div class="pricing__box">
                            <div class="pricing__head">
                                <h5 class="title"><?php echo e($package->name); ?></h5>
                            </div>
                            <div class="pricing__price">
                                <h2 class="price monthly_price"> <?php echo e($package->price); ?><span>/ <?php echo e($package->duration); ?></span></h2>
                                <h2 class="price annual_price"><?php echo e($package->annual_price); ?> <span>/ <?php echo e(__('Yearly')); ?></span></h2>
                            </div>
                            <div class="pricing__list">
                                <ul class="list-wrap">
                                    <?php $__currentLoopData = $package->feature_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <span>
                                                <?php if($feature['is_available']): ?>
                                                    <i class="fa fa-check text-success"></i>
                                                <?php else: ?>
                                                    <i class="fa fa-ban text-danger"></i>
                                                <?php endif; ?>
                                                <span class="ms-2"><?php echo e($feature['value']); ?></span>
                                            </span>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <?php if(($buttonLabel = $package->getMetaData('action_label', true))
                                && ($buttonUrl = $package->getMetaData('action_url', true))): ?>
                                <div class="pricing__btn">
                                    <a href="<?php echo e($buttonUrl); ?>" class="btn"><?php echo BaseHelper::clean($buttonLabel); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/pricing/index.blade.php ENDPATH**/ ?>