<?php
    $bgColor = $shortcode->background_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;
    $image = $shortcode->image;
    $image1 = $shortcode->image_1;

    $variablesStyle = [
        "--background-color: $bgColor" => $bgColor,
        "--background-image: url($bgImage)" => $bgImage,
    ];
?>

<section
    class="<?php echo \Illuminate\Support\Arr::toCssClasses([
        'shortcode-hero-banner banner-area banner-bg',
         'banner__bg-three' => $image,
         'has-header-transparent-and-ecommerce' =>
         theme_option('display_header_top', true)
         && theme_option('is_header_transparent')
         && is_plugin_active('ecommerce')
    ]); ?>"
    style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>"
>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="<?php echo e(theme_option('header_style') == 3 ? 'banner__content-three' : 'banner-content'); ?>">
                    <?php if($subtitle = $shortcode->subtitle): ?>
                        <span class="sub-title" data-aos="fade-up" data-aos-delay="0"><?php echo BaseHelper::clean($subtitle); ?></span>
                    <?php endif; ?>

                    <?php if($title = $shortcode->title): ?>
                        <h2 class="title" data-aos="fade-up" data-aos-delay="200"><?php echo BaseHelper::clean($title); ?></h2>
                    <?php endif; ?>

                    <?php if($description = $shortcode->description): ?>
                        <p data-aos="fade-up" data-aos-delay="400"><?php echo BaseHelper::clean($description); ?></p>
                    <?php endif; ?>

                    <?php if(($buttonLabel = $shortcode->button_label) && ($buttonUrl = $shortcode->button_url)): ?>
                        <a href="<?php echo e($buttonUrl); ?>" class="btn" data-aos="fade-up" data-aos-delay="600"><?php echo BaseHelper::clean($buttonLabel); ?></a>
                    <?php endif; ?>
                </div>
            </div>

            <?php
                $image = $shortcode->image;
                $image1 = $shortcode->image_1;
            ?>
            <?php if($image || $image1): ?>
                <div class="col-lg-6">
                    <div class="banner__img-two">
                        <?php if($image): ?>
                            <?php echo e(RvMedia::image($image, $title)); ?>

                        <?php endif; ?>

                        <?php if($image1): ?>
                            <?php echo e(RvMedia::image($image1, $title)); ?>

                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <?php if($shortcode->display_social_links && ($items = Theme::getSocialLinks())): ?>
            <div class="banner-social">
                <h5 class="title"><?php echo e(__('Follow us')); ?></h5>
                <ul class="list-wrap">
                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a title="<?php echo e($item->getName()); ?>" href="<?php echo e($item->getUrl()); ?>">
                                <?php echo $item->getIconHtml(); ?>

                            </a>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if($shortcode->display_button_scroll_down): ?>
            <div class="banner-scroll">
                <a href="#footer"> <?php echo e(__('Scroll Down')); ?> <span><i class="fas fa-arrow-right"></i></span></a>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/hero-banner/index.blade.php ENDPATH**/ ?>