<?php
    $bgColor = $shortcode->background_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;
    $variablesStyle = [
        "--background-color: $bgColor" => $bgColor,
        "--background-image: url($bgImage)" => $bgImage,
    ];
?>

<section class="consulting-area shortcode-consulting-block" style="<?php echo \Illuminate\Support\Arr::toCssStyles($variablesStyle) ?>">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="consulting-inner-wrap shine-animate-item">
                    <div class="consulting-content">

                        <?php if(($dataCount = $shortcode->data_count) && ($dataCountDescription = $shortcode->data_count_description)): ?>
                            <div class="content-left">
                                <h2 class="title"><?php echo BaseHelper::clean($dataCount); ?></h2>
                                <span> <?php echo BaseHelper::clean($dataCountDescription); ?> </span>
                            </div>
                        <?php endif; ?>

                        <div class="content-right">
                            <?php if($title = $shortcode->title): ?>
                                <h2 class="title"><?php echo BaseHelper::clean($title); ?></h2>
                            <?php endif; ?>

                            <?php if($description = $shortcode->description): ?>
                                <p class="truncate-2-custom"><?php echo BaseHelper::clean($description); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php if($image = $shortcode->image): ?>
                        <div class="consulting-img shine-animate">
                            <?php echo e(RvMedia::image($image, 'Consulting Image')); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section><?php /**PATH C:\xampp\htdocs\Mane_website\platform\themes/apexa/partials/shortcodes/consulting-block/index.blade.php ENDPATH**/ ?>